#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
//-----------------------------------------------------------------------------
// Include files
//-----------------------------------------------------------------------------
#include <windows.h>
#include <ddraw.h>
#include <dinput.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "resource.h"
#include "ddutil.h"
#include "fixed.h"
#include <math.h>
#include "GameConfig.cfg"
#include <typeinfo.h>
#include <time.h>

#include "Tdinput.h"

//-----------------------------------------------------------------------------
// Local definitions
//-----------------------------------------------------------------------------
#define NAME                "A Game"
#define TITLE               "A Game"

//-----------------------------------------------------------------------------
// Global data
//-----------------------------------------------------------------------------
LPDIRECTDRAW4               DirectDraw	= NULL;     // DirectDraw object
LPDIRECTDRAWSURFACE4        FrontBuffer = NULL;		// DirectDraw primary surface
LPDIRECTDRAWSURFACE4        BackBuffer	= NULL;		// DirectDraw back surface
LPDIRECTDRAWSURFACE4        SpaceShip	= NULL;		// Offscreen Bitmap surface
LPDIRECTDRAWSURFACE4        GUISurface	= NULL;		// Offscreen GUI Bitmap surface
LPDIRECTDRAWSURFACE4		Starfield	= NULL;		// Offscreen Star surface
LPDIRECTDRAWPALETTE			Palette256	= NULL;     // The primary surface palette
LPDIRECTDRAWCLIPPER			Clipper		= NULL;		// The Sprite Clipper
BOOL                        g_bActive = FALSE;		// Is application active?


const float M_PI  =  3.14159265359f;
const float M_2PI =	 6.28318530718f; 

const bool invulnerable = false; 
const float animframes = 16.0;
//-----------------------------------------------------------------------------
// Local data
//-----------------------------------------------------------------------------
// Name of our bitmap resource.
static char                 szBitmap[]	 = "ASTSHFR";
static char                 szGui[]		 = "GUI";
static char                 PlayerName[] = "Oz";
// Space Ship start Position.
signed __int16 WorldX = 0, WorldY = 0;
// Rotational Frame.
int rot = 0;

unsigned __int16 Score = 0;
unsigned __int16 DamageFactor = 1;
// Used to "desensitize" the key presses.
float krot = 0.0f;
// Used to say whether the ship should move or not.
int thrust = 0;

bool Fire = false;

bool readkey = false;

bool Pause = false;

bool KeyboardLost = false;

__int16 MouseX = 320, MouseY = 240;

bool MainMenu = true;
bool OptionsMenu = false;
bool QuitMessage = false;

// Pointer to the Direct Input Interface.

TDInput *ti;

HWND                        hWnd;
HINSTANCE					hInstance;
//-----------------------------------------------------------------------------
// Name: ReleaseAllObjects()
// Desc: Finished with all objects we use; release them
//-----------------------------------------------------------------------------
static void
ReleaseAllObjects(void)
{
    if (DirectDraw != NULL)
    {
        if (FrontBuffer != NULL)
        {
            FrontBuffer->Release();
            FrontBuffer = NULL;
        }
        if (SpaceShip != NULL)
        {
            SpaceShip->Release();
            SpaceShip = NULL;
        }
		if (GUISurface != NULL)
		{
			GUISurface->Release();
			GUISurface = NULL;
		}
		if (Starfield != NULL)
        {
            Starfield->Release();
            Starfield = NULL;
        }
		if (Clipper != NULL)
        {
            Clipper->Release();
            Clipper = NULL;
        }
		if (Palette256 != NULL)
        {
            Palette256->Release();
            Palette256 = NULL;
        }

        DirectDraw->Release();
        DirectDraw = NULL;
    }
}




//-----------------------------------------------------------------------------
// Name: InitFail()
// Desc: This function is called if an initialization function fails
//-----------------------------------------------------------------------------
HRESULT
InitFail(HWND hWnd, HRESULT hRet, LPCTSTR szError,...)
{
    char                        szBuff[128];
    va_list                     vl;

    va_start(vl, szError);
    vsprintf(szBuff, szError, vl);
    ReleaseAllObjects();
    MessageBox(hWnd, szBuff, TITLE, MB_OK);
    DestroyWindow(hWnd);
    va_end(vl);
    return hRet;
}

//-----------------------------------------------------------------------------
// Name: RestoreAll()
// Desc: Restore all lost objects
//-----------------------------------------------------------------------------
HRESULT 
RestoreAll(void)
{
    HRESULT                     hRet;

    hRet = FrontBuffer->Restore();
    if (hRet == DD_OK)
    {
        hRet = SpaceShip->Restore();
        if (hRet == DD_OK)
        {
            DDReLoadBitmap(SpaceShip, szBitmap);
        }
		hRet = GUISurface->Restore();
        if (hRet == DD_OK)
        {
            DDReLoadBitmap(GUISurface, szGui);
		}

    }
	Starfield->Restore();
	BackBuffer->Restore();
	/*Clipper->Restore();
	DirectDraw->Restore();*/
    // Loose the old palette
    Palette256->Release();
    // Create and set the palette (restart cycling from the same place)
    Palette256 = DDLoadPalette(DirectDraw, szBitmap);

    if (Palette256)
        FrontBuffer->SetPalette(Palette256);

    return hRet;
}




//-----------------------------------------------------------------------------
// Name: UpdateFrame()
// Desc: Decide what needs to be blitted next, wait for flip to complete,
//       then flip the buffers.
//-----------------------------------------------------------------------------
void ClearBackBuffer(int color = 0)
{
	DDBLTFX ddbltfx;
	ddbltfx.dwSize = sizeof(DDBLTFX);
	ddbltfx.dwFillColor = color;
    BackBuffer->Blt(NULL, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbltfx);
}
void ClearBackgr(int color = 0)
{
	DDBLTFX ddbltfx;
	ddbltfx.dwSize = sizeof(DDBLTFX);
	ddbltfx.dwFillColor = color;
    Starfield->Blt(NULL, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbltfx);
}

void SetPixel(LPVOID pv,int next_scan, int x, int y, BYTE colour)
{
	if ((x > 0 && x < 640) && (y > 0 && y < 480))
	{
		BYTE *p = (BYTE*)pv;
		p += (x + (next_scan * y));
		*p = colour;
	};
}
void VLine(LPVOID pv, int next_scan, int x, int y1, int y2, BYTE colour)
{
	if (y1 > y2)
	{	
		int temp = y1;
		y1 = y2;
		y2 = temp;
	}

	int y = y1;
	
	while (y <= y2)
	{
		SetPixel(pv, next_scan, x, y, colour);
		y++;
	};
}
void HLine(LPVOID pv, int next_scan, int x1, int y, int x2, BYTE colour)
{
	if (x1 > x2)
	{	
		int temp = x1;
		x1 = x2;
		x2 = temp;
	}

	int x = x1;

	while (x <= x2)
	{	
		SetPixel(pv, next_scan, x, y, colour);
					
		x++;
	};
};
void Line(LPVOID pv, int next_scan, int x1, int y1, int x2, int y2, BYTE colour)
{
	
	if (y1 > y2)
	{	
		int temp = y1;
		y1 = y2;
		y2 = temp;
		temp = x1;
		x1 = x2;
		x2 = temp;

	}

	Fixed dx = (Fixed)(x1 - x2) / (Fixed)(y1 - y2);
	Fixed x = x1;
	Fixed oldx = x1;
	int y = y1;
	
	while (y <= y2)
	{
		HLine(pv, next_scan, x, y, oldx , colour);
		oldx = x;
		y++;
		x += dx;
	};
	if (y1 == y2)
		HLine(pv, next_scan, x1, y1, x2, colour);
}
class TStarfield
{
	private:
		float X;
		float Y;
		int Speed;
		int Col;
		float Dir;
		int Thrust;
		
	public:
		TStarfield() {};
		void InitStar()
		{
			X = rand() % 640;
			Y = rand() % 480;
			Speed = ((rand() % 14)) + 2;
			Col = (15 - Speed) + 15;
			Dir = 0;
		}
		void InitStar2()
		{
			//bool temp;
			if (X < 0) Y = rand() % 480, X = 640;
			if (X > 640) Y = rand() % 480, X = 0;
			if (Y < 0 ) X = rand() % 640, Y = 480;
			if (Y > 480) X = rand() % 640, Y = 0;

			Speed = ((rand() % 14)) + 2;
			Col = (15 - Speed) + 15;
		}
		int GetX() { return X; }
		int GetY() { return Y; }
		int GetCol() { return Col; }
		int GetSpeed() { return Speed; }
		
		void SetX(float x) { X = x; }
		void SetY(float y) { Y = y; }
		void SetCol(int col) { Col = col; }
		void SetSpeed(int speed) { Speed = speed; }
		void SetDir(float dir) { Dir = dir; }
		void SetThrust(int thrust) { Thrust = thrust; }

		void NextFrame()
		{
			float speed = (Speed * Thrust) / 2;

			float angle = (Dir / animframes) * (M_2PI);
			
			float x = speed * sin(angle);
			float y = speed * cos(angle);

			X -= x;
			Y += y;

		}
};			
class TSpaceShip
{
	protected:
		//float X;
		signed __int16 X;

		//float Y;
		signed __int16 Y;

		float Dir;

		unsigned __int8 Thrust;
		unsigned __int8 Health;
		unsigned __int8 DamageFactor;

		bool Activ;
		bool Fire;
		
		char *Name;

		unsigned __int8 FireOffset;

		bool Launch;
		
		unsigned __int8 MissileNum;
	
		signed __int8 ship;
		
		unsigned __int8 OwnerID;
		
		RECT FrameData;
		
		unsigned __int16 Score;


	public:
		TSpaceShip() { Activ = false; Score = 0;}
		
		void InitSpaceShip (int x, int y, int dir, int thrust, int ownerID, char* name = "Drone", int health = 10)
		{
			X = x;
			Y = y;
			Dir = dir;
			Thrust = thrust;
			Fire = false;
			Launch = false;
			MissileNum = 10;
			Name = name;
			Health = health;
			OwnerID = ownerID;
			DamageFactor = 1;
			//ship = rand() % TotalShips;
		}
		__int16 GetX()			{ return X; }
		__int16 GetY()			{ return Y; }
		__int8 GetDirection()	{ return Dir; }
		unsigned __int8 GetThrust()		{ return Thrust; }
		unsigned __int8 GetHealth()		{ return Health;}
		unsigned __int16 GetScore()		{ return Score;}
		unsigned __int8 GetMissileNum()	{ return MissileNum;}

		char *GetName()		{ return Name; }
		bool IsFiring()		{ return Fire; }
		bool IsLaunching()	{ return Launch; }
		bool Active()		{ return Activ; }
		
		void Active(bool active) 
		{ 
			Activ = active;
			if (Activ == false) Thrust = 0;
		}
		
		void AddScore(int score) { Score += score;}

		void Damage( int damage) 
		{ 
			signed __int16 temp = Health - damage;
			if (temp < 1) Active(false);
			else 
			{	
				if (temp > 100) temp = 100;
				Health = temp; 
			}
		}
		
		void Set2xDamageFactor()
		{
			if (DamageFactor < 8) 
				DamageFactor *= 2;
		}
		
		unsigned __int8 GetDamageFactor() { return DamageFactor; }
		
		void AddMissiles(int num) 
		{ 
			int temp = MissileNum + num;
			if (temp > 15) temp = 15;
			MissileNum = temp; 
		}


		void SetX(signed __int16 x) { X = x; }
		void SetY(signed __int16 y) { Y = y; }

		void SetDirection(int dir) { Dir = dir; }
		void SetFire(bool fire) { Fire = fire; }		
		void SetThrust(int thrust) { Thrust = thrust; }
		
		void SetLaunch(bool launch) 
		{ 
			if (MissileNum > 0 && launch) 
			{
				Launch = true; 
				MissileNum--;
			} else Launch = false;

		}

		void SetName(char *name) { Name = name; }
		
		virtual void NextFrame() = 0;
		
		RECT GetFrameData() { return FrameData; }
};

TSpaceShip **Ship;

class TDrone : public TSpaceShip
{
	private:
		void GetNearest()
		{
			{
				auto float *dx;
				auto float *dy;
				auto float *dr;
				dx = new float[TotalShips];
				dy = new float[TotalShips];
				dr = new float[TotalShips];
				auto int loop = 0;

				while (loop < TotalShips)
				{
					dx[loop] = Ship[loop]->GetX() - this->GetX();
					dy[loop] = Ship[loop]->GetY() - this->GetY();
					dr[loop] = sqrt((dx[loop] * dx[loop]) + (dy[loop] * dy[loop]));
					loop++;
				};
				
				loop = 0;
				auto float Min = 65535;
				ship = -1;
				while (loop < TotalShips)
				{
					if ((dr[loop] < Min) && (loop != OwnerID)) Min = dr[loop], ship = loop;
					loop++;
				};
				delete[] dx;
				delete[] dy;
				delete[] dr;
			}
		};
		void RandomMovement()
		{
			if ((rand() % 16) == 1) Dir ++;
			if ((rand() % 16) == 14) Dir --;
		
			if (Dir < 0) Dir = 15;
			if (Dir > 15) Dir = 0;
		};
		void EvasiveMovement()
		{
			if (ship >= 0 && ship <= TotalShips)	
			{
				//int ship = 0;
				float dx = Ship[ship]->GetX() - X;
				float dy = Ship[ship]->GetY() - Y;

				float dr = sqrt((dx * dx) + (dy * dy));
				
				float angle = asin(dx / dr);
				
				if (dy > 0) angle = -angle;
				if (dy < 0) angle += M_PI;
				
				angle /= (M_2PI);
				angle *= animframes + 1;

				if (dr < 100) Fire = !Fire;
				if (dr > 100) Fire = false;

				if (dr > 300) Thrust = 1;
				if (dr < 300) Thrust = 2;
				if (dr < 90) Thrust = 3;
				

				Dir = (int)angle;
			}			
			if (Dir < 0) Dir += 16;
			if (Dir > 15) Dir -= 16;
		};
		void TrackingMovement()
		{
			//if (Ship[ship]->Active())
			if (ship >= 0 && ship <= TotalShips)
			{
				//int ship = 0;
				
				float dx = Ship[ship]->GetX() - X;
				float dy = Ship[ship]->GetY() - Y;
			
				float dr = sqrt(pow(dx,2) + pow(dy,2));

				if (Ship[ship]->IsFiring() && dr < 200 && (rand() % 2) == 1)
				{
					EvasiveMovement();
					return;
				};
				dr += (rand() % 100) - 50;
				float angle = (M_PI) + asin(dx / dr);
		
				if (dy > 0) angle = -angle;
				if (dy < 0) angle += M_PI;
			
				angle /= (M_2PI);
				angle *= animframes + 1;

				if (dr < 100) Fire = !Fire;
				if (dr > 100) Fire = false;
				
				if (dr > 300) Thrust = 3;
				if (dr < 300) Thrust = 2;
				if (dr < 90) Thrust = 1;
				

				Dir = (int)angle;
			}				
			if (Dir < 0) Dir += 16;
			if (Dir > 15) Dir -= 16;
		};
		
	public:
		
		void NextFrame()
		{
			if ((rand() % 20) == 1) GetNearest();
			//GetNearest();
			if ((rand() % 10) == 1) TrackingMovement();
			if ((rand() % 10) == 2) RandomMovement();
			{
				int thrust = Thrust * 3;
			
				float angle = (Dir / animframes) * (M_2PI);
			
				float x = thrust * sin(angle);
				float y = thrust * cos(angle);

				X += x;
				Y -= y;
			}

			FireOffset = 0;
			if (Fire) FireOffset = 31;

			FrameData.left = 0 + (Dir * 30) + Dir;
			FrameData.top = 62 + FireOffset;
			FrameData.right = 30 + (Dir * 30) + Dir;
			FrameData.bottom = 92 + FireOffset;
		
		}

		
};
class TPlayer : public TSpaceShip
{
	
	public:
						
		void NextFrame()
		{
			int offset = 0;
			if (Fire) offset = 31;

			FrameData.left = 0 + ((Dir * 30) + Dir);
			FrameData.top = 0 + offset;
			FrameData.right = 30 + ((Dir * 30) + Dir);
			FrameData.bottom = 30 + offset;
		};

		
};
class TMissile
{
	private:
		float X;
		float Y;
		float Dir;
		int Thrust;
		float CurrentThrust;
		bool Activ;
		TSpaceShip *Owner;		
		int OwnerNum;
		RECT FrameData;

		int MinIndex;
		void TrackingMovement()
		{
			{
				float *dx;
				float *dy;
				float *dr;

				dx = new float[TotalShips];
				dy = new float[TotalShips];
				dr = new float[TotalShips];
				
				
				int loop = 0;

				while (loop < TotalShips)
				{
					dx[loop] = Ship[loop]->GetX() - X;
					dy[loop] = Ship[loop]->GetY() - Y;
			
					dr[loop] = sqrt(pow(dx[loop],2) + pow(dy[loop],2));
					loop++;
				};
				
			
			
				float Min = dr[playernum];
				MinIndex = playernum;
				
				loop = 0;
							
				while (loop < TotalShips)
				{
					if (dr[loop] < Min && loop != OwnerNum)
					{
						Min = dr[loop];
						MinIndex = loop;
					}
					loop++;
				};
			
				float angle = (M_PI) + asin(dx[MinIndex] / dr[MinIndex]);
		
				if (dy[MinIndex] > 0) angle = -angle;
				if (dy[MinIndex] < 0) angle += M_PI;
				
				angle /= (M_2PI);
				angle *= animframes + 1;
				
				Thrust = 3;

				Dir = (int)angle;
				
				delete[] dx;
				delete[] dy;
				delete[] dr;
			}			
			if (Dir < 0) Dir += 16;
			if (Dir > 15) Dir -= 16;
			
			
		};
	public:	
		TMissile() { Activ = false; Score = 0;}

		void InitMissile (int x, int y, int dir, int thrust, TSpaceShip *owner, int Ownernum)
		{
			X = x;
			Y = y;
			Dir = dir;
			Thrust = thrust;
			Owner = owner;
			OwnerNum = Ownernum;
			CurrentThrust = 0.0f;
		}
		int GetX()			{ return X; }
		int GetY()			{ return Y; }
		int GetDirection()	{ return Dir; }
		bool Active()		{ return Activ; }
		void Active(bool active) 
		{ 
			Activ = active;
			if (Activ == false) Thrust = 0;
		}
		TSpaceShip* GetOwner() { return Owner; }

		
		RECT GetFrameData() { return FrameData; }

		/*void SetX(int x) { X = x; }
		void SetY(int y) { Y = y; }
		void SetDirection(int dir) { Dir = dir; }
		void SetFire(bool fire) { Fire = fire; }		
		void SetThrust(int thrust) { Thrust = thrust; }*/
		
		
		void NextFrame()
		{
			
			
			CurrentThrust += 0.25;
			if (CurrentThrust > Thrust * 4) 
			{
				CurrentThrust = Thrust * 4;
				TrackingMovement();
			};
			{
				int thrust = CurrentThrust;
			
				float angle = (Dir / animframes) * (M_2PI);
			
				float x = thrust * sin(angle);
				float y = thrust * cos(angle);
	
				X += x;
				Y -= y;
			};
			FrameData.left = 0 + ((Dir * 14));
			FrameData.top = 185;
			FrameData.right = 12 + ((Dir * 14));
			FrameData.bottom = 197;
		};

		
};
class TFire
{
	private:
		signed __int16 X;
		signed __int16 Y;
		float Dir;
		int Thrust;
		bool Activ;
		unsigned __int8 OwnerID;
	public:
		TFire() {Activ = false;}

		void InitFire(int x, int y, float dir, int thrust, int owner)
		{
			X = x;
			Y = y;
			Dir = dir;
			Thrust = thrust * 3;
			OwnerID = owner;
		}

		int GetX() { return X; }
		int GetY() { return Y; }
		unsigned __int8 GetOwner() { return OwnerID; }

		bool Active() { return Activ; }
		void Active(bool active) { Activ = active; }
		
		void NextFrame()
		{
			int speed = (10 + Thrust);
			float angle = (Dir / animframes) * (M_2PI);
			
			float x = speed * sin(angle);
			float y = speed * cos(angle);

			X += x;
			Y -= y;
		}
};
class TParticles
{
	private:
		int   numparticles;
		float *X;
		float *Y;
		float *Dir;
		float *Thrust;
		int	  *Colour;
		bool  Activ;
		float XStep;
		float YStep;
	public:
	
		TParticles() 
		{ 
			Activ = false; 
			numparticles = ExplosionParticles; 
			X		= new float	[ExplosionParticles];
			Y		= new float	[ExplosionParticles];
			Dir		= new float	[ExplosionParticles];
			Thrust	= new float	[ExplosionParticles];
			Colour	= new int	[ExplosionParticles];
		}
		~TParticles()
		{
			delete[] X;
			delete[] Y;
			delete[] Dir;
			delete[] Thrust;
			delete[] Colour;
		}
		void InitParticles(int x, int y)
		{
			int loop = 0;
			while (loop < numparticles)
			{
				X[loop] = x;
				Y[loop] = y;
				Dir[loop] = (rand() % 1600) / 100.0;
				Thrust[loop] = (rand() % 200) / 35.0;

				Colour[loop] = ((Thrust[loop] / 5.0) * 16) + 58;
				if (Colour[loop] > 80) Colour[loop] = 80;
				//Colour[loop] = 65 + (rand() % 16);
				loop++;
			};
		}
		bool Active()				{ return Activ; }
		int GetX(int index)			{ return X[index]; }
		int GetY(int index)			{ return Y[index]; }
		int GetColour(int index)	{ return Colour[index]; }
		int GetNumParticles()		{ return numparticles; }

		void Active(bool active)	{ Activ = active; }

		void NextFrame()
		{
			int loop = 0;
			while (loop < numparticles)
			{
				{
					float angle = (Dir[loop] / animframes) * (M_2PI);
			
					float x = Thrust[loop] * sin(angle);
					float y = Thrust[loop] * cos(angle);
					
					if (randomjitter)
					{
						X[loop] += x + (((rand() % 100) - 50) / 25.0);
						Y[loop] -= y + (((rand() % 100) - 50) / 25.0);
					} else
					{
						X[loop] += x;
						Y[loop] -= y;
					}


					Thrust[loop] -= 0.1f;
			
					if (Thrust[loop] < 0) 
					{
						Thrust[loop] = 0.0f;
						Colour[loop] ++;
						if (Colour[loop] > 79) Colour[loop] = 79;
					}
				}
				loop++;
			};
			

		}
		
};
class TSmoke
{
	private:
		int numparticles;
		float *X;
		float *Y;
		float Dir;
		float *Thrust;
		int *Colour;
		bool Activ;
		int *counter;
		int LowColour;
		int HighColour;
		
	public:
	
		TSmoke() 
		{
			Activ = false; 
			numparticles = SmokeParticles; 
			
			X = new float[SmokeParticles];
			Y = new float[SmokeParticles];
			Thrust = new float[SmokeParticles];
			Colour = new int[SmokeParticles];
			counter = new int[SmokeParticles];
		}
		~TSmoke()
		{
			delete[] X;
			delete[] Y;
			delete[] Thrust;
			delete[] Colour;
			delete[] counter;
		}
		void InitSmoke(int x, int y, int Dir, int lowColour = 66, int highColour = 65)
		{
			int loop = 0;
			
			while (loop < numparticles)
			{
				X[loop] = x;
				Y[loop] = y;

				

				Thrust[loop] = (rand() % 200) / 20.0;
				Colour[loop] = ((Thrust[loop] / 5.0) * 16) + lowColour;
				if (Colour[loop] > 79) Colour[loop] = highColour;
				LowColour = lowColour;
				HighColour = highColour;
				counter[loop] = 0;
				loop++;
				
			};
		}
		bool Active()				{ return Activ; }
		
				
		void SetDirection(int dir)  { Dir = dir; }

		int GetX(int index)			{ return X[index]; }
		int GetY(int index)			{ return Y[index]; }
		int GetColour(int index)	{ return Colour[index]; }
		int GetNumParticles()		{ return numparticles; }
		
		void Active(bool active)	{ Activ = active; }

		void NextFrame(int x1, int y1)
		{
			int loop = 0;
			while (loop < numparticles)
			{
				{
					float dir;
					
					dir = (int)(Dir - 8.0f);
					
					float angle = (dir / animframes) * (M_2PI);
			
					float x = Thrust[loop] * sin(angle);
					float y = Thrust[loop] * cos(angle);

					X[loop] += x;
					Y[loop] -= y;
					Thrust[loop] -= 0.1f;
					counter[loop] ++;
		
					if (counter[loop] > (rand() % 10))
					{
						X[loop] = x1 + (rand() % 5) - 2;
						Y[loop] = y1 + (rand() % 5) - 2;
						Thrust[loop] = (rand() % 200) / 40.0;
						Colour[loop] = ((Thrust[loop] / 5.0) * 16) + LowColour;
						if (Colour[loop] > HighColour) Colour[loop] = HighColour;
				
						counter[loop] = 0;
					}
				}
				loop++;
			};
			

		}
		
};
class TPowerUp
{
	protected:
		signed __int16 X;
		signed __int16 Y;
		unsigned __int8 Num;
		RECT FrameData;
	public:
		TPowerUp() {}
		
		virtual void InitPowerUp(int) = 0;
		
		signed __int16 GetX() { return X; }
		signed __int16 GetY() { return Y; }
		unsigned __int8 GetNum() { return Num; }
		
		RECT GetFrameData() { return FrameData; }

};

class TPUMissile : public TPowerUp
{
	public:
		void InitPowerUp(int num)
		{
			Num = num;
			__int32 x,y;

			x = (rand() % 65536) - 32768;
			y = (rand() % 65536) - 32768;
			
			X = x;
			Y = y;
			
			FrameData.left   = 0;
			FrameData.top    = 199; 
			FrameData.right  = 17; 
			FrameData.bottom = 218; 
		}

};

class TPUHealth10 : public TPowerUp
{
	public:
		void InitPowerUp(int num)
		{
			Num = num;

			__int32 x,y;

			x = (rand() % 65536) - 32768;
			y = (rand() % 65536) - 32768;
			
			X = x;
			Y = y;
			
			FrameData.left   = 18;
			FrameData.top    = 199; 
			FrameData.right  = 35; 
			FrameData.bottom = 218; 
		}

};

class TPUHealth25 : public TPowerUp
{
	public:
		void InitPowerUp(int num)
		{
			Num = num;

			__int32 x,y;

			x = (rand() % 65536) - 32768;
			y = (rand() % 65536) - 32768;
			
			X = x;
			Y = y;
			
			FrameData.left   = 36;
			FrameData.top    = 199; 
			FrameData.right  = 53; 
			FrameData.bottom = 218; 
		}

};

class TPUHealth50 : public TPowerUp
{
	public:
		void InitPowerUp(int num)
		{
			Num = num;

			__int32 x,y;

			x = (rand() % 65536) - 32768;
			y = (rand() % 65536) - 32768;
			
			X = x;
			Y = y;
			
			FrameData.left   = 54;
			FrameData.top    = 199; 
			FrameData.right  = 71; 
			FrameData.bottom = 218; 
		}

};

class TPU2xFireDist : public TPowerUp
{
	public:
		void InitPowerUp(int num)
		{
			Num = num;

			__int32 x,y;

			x = (rand() % 65536) - 32768;
			y = (rand() % 65536) - 32768;
			
			X = x;
			Y = y;
			
			FrameData.left   = 72;
			FrameData.top    = 199; 
			FrameData.right  = 89; 
			FrameData.bottom = 218; 
		}

};

TPowerUp   **tp;

TStarfield ts[100];
TStarfield tsold[100];

TMissile   Missile[20];
TSmoke	   MissileSmoke[20];

int		   missilecount = 0;
int		   missilecounter[20];

TParticles *Particle[10];
int		   particlecount = 0;
int		   particlecounter[10];

TSmoke	   *Smoke;

TFire	   shot[100];
int		   shotcount = 0;
int		   shotcounter[100];


void InitStarfield()
{
	int loop = 0;
	while (loop < 100)
	{
		ts[loop].InitStar();
		tsold[loop].SetX(ts[loop].GetX());
		tsold[loop].SetY(ts[loop].GetY());
		tsold[loop].SetCol(ts[loop].GetCol());
		tsold[loop].SetSpeed(ts[loop].GetSpeed());
		loop ++;
	};
}
void NextFrame(__int16 &WorldX, __int16 &WorldY )
{

	float Dir = krot;
	int Thrust = thrust * 3;
	
	float angle = (Dir / animframes) * (M_2PI);
	
	float x = Thrust * sin(angle);
	float y = Thrust * cos(angle);

	WorldX += x;
	WorldY -= y;
}

void SetDir(float dir)
{
	int loop = 0;
	while (loop < 100)
	{
		ts[loop].SetDir(dir);
		tsold[loop].SetDir(dir);
		loop ++;
	};
}
void SetThrust(int dir)
{
	int loop = 0;
	while (loop < 100)
	{
		ts[loop].SetThrust(dir);
		tsold[loop].SetThrust(dir);
		loop ++;
	};
}

void CheckForCollision()
{
	int loop = 0, loop2 = 0, x, y, top, left, bottom, right;
	
	if (invulnerable) loop = playernum;
	
	while (loop < TotalShips)
	{
		left = Ship[loop]->GetX() - 15;
		top = Ship[loop]->GetY() - 15;

		right = Ship[loop]->GetX() + 15;
		bottom = Ship[loop]->GetY() + 15;
	
		loop2 = 0;
		while (loop2 < 100)
		{
			if (shot[loop2].Active() && shot[loop2].GetOwner() != loop
				&& Ship[loop]->Active() /*!= NULL*/)
			{
				x = shot[loop2].GetX();
				y = shot[loop2].GetY();
			
			
				if (((x > left) && (x < right)) &&
					((y > top) && (y < bottom)))
				{
					shot[loop].Active(false);	
					shotcounter[loop] = 0;
					Ship[loop]->Damage(1 * Ship[shot[loop].GetOwner()]->GetDamageFactor());
					
					if (!Ship[loop]->Active())
					{
						//if (Particle[particlecount] != NULL) delete Particle[particlecount];
						
						x = left + 15;
						y = top + 15;

						if ((x > (WorldX - 370)) && (x < (WorldX + 370)) && (y > (WorldY - 290)) && (y < (WorldY + 290)))
						{
							Particle[particlecount] = new TParticles();
									
							Particle[particlecount]->InitParticles(x, y);
							Particle[particlecount]->Active(true);
							particlecounter[particlecount] = 0;
							particlecount ++;

							if (particlecount == 10) particlecount = 0;
						}
						if (Ship[shot[loop2].GetOwner()]->Active());
						{
							
							Ship[shot[loop2].GetOwner()]->AddScore(100);
							if (shot[loop2].GetOwner() == playership - 1) Ship[playership - 1]->AddScore(Ship[loop]->GetScore());
						}
						
						Ship[loop]->Active(false);				
						if (loop != (playership - 1))
						{
							delete Ship[loop];
							Ship[loop] = NULL;

							if ((Ship[loop] = new TDrone()) != 0)
							{
								Ship[loop]->InitSpaceShip(((rand() % 32767) - 16384),((rand() % 32767) - 16384), 0, 1,loop);
								Ship[loop]->Active(true);
							}
							
						} else thrust = 0;
					}

				}
			};
			loop2++;
		};
		loop2 = 0;
		while (loop2 < 20)
		{
			if (Missile[loop2].Active() && Missile[loop2].GetOwner() != Ship[loop]
				&& Ship[loop]->Active())
			{
				x = Missile[loop2].GetX();
				y = Missile[loop2].GetY();
			
			
				if (((x >= left) && (x <= right)) &&
					((y >= top) && (y <= bottom)))
				{
					
					Ship[loop]->Damage(11);
					Missile[loop2].Active(false);

					if (!Ship[loop]->Active())
					{
						if ((x > (WorldX - 370)) && (x < (WorldX + 370)) && (y > (WorldY - 290)) && (y < (WorldY + 290)))
						{
							Particle[particlecount] = new TParticles();
									
							Particle[particlecount]->InitParticles(x, y);
							Particle[particlecount]->Active(true);
							particlecounter[particlecount] = 0;
							particlecount ++;

							if (particlecount == 10) particlecount = 0;
						}	
						//if (Ship[playership - 1]->Active()) 

						Missile[loop2].GetOwner()->AddScore(50);

						if (Missile[loop2].GetOwner() == Ship[playership - 1])Ship[playership - 1]->AddScore(Ship[loop]->GetScore());
						
						Ship[loop]->Active(false);				
						
						if (loop != (playership - 1))
						{
							
							delete[] Ship[loop];
							Ship[loop] = NULL;

							if ((Ship[loop] = new TDrone()) != 0)
							{
								Ship[loop]->InitSpaceShip(((rand() % 32767) - 16384),((rand() % 32767) - 16384), 0, 1,loop);
								Ship[loop]->Active(true);
							} /*InitFail(NULL,NULL,"Bugger");*/
						} else thrust = 0;
					}

				}
			};
			loop2++;
		};
		loop++;
	};
}
void Blit(RECT srcRect, RECT destRect, LPDIRECTDRAWSURFACE4 surf, int FX = DDBLT_KEYSRC | DDBLT_WAIT)
{
	HRESULT hRet;
	if (!((destRect.left > 640) || (destRect.right < 0) || (destRect.top > 480) || (destRect.bottom < 0)))
	{
		while (TRUE)
		{
			//hRet = BackBuffer->BltFast(ozxpos, ozypos, SpaceShip, &srcRect, DDBLTFAST_SRCCOLORKEY);
			DDBLTFX		ddbltfx;
			
			ddbltfx.dwSize = sizeof(DDBLTFX);
			
			hRet = BackBuffer->Blt(&destRect, surf, &srcRect, FX, &ddbltfx);

			if (hRet == DD_OK)
				break;
			if (hRet != DDERR_WASSTILLDRAWING)
				return;
		}
	}
};

void OzText(int x, int y, char* text, int len)
{
	RECT srcRect, destRect;
	{
		int temp;
		temp = len;
		temp *= 7;
		temp /= 2;
		x -= temp;
		y -= 4;
	}
	int loop = 0;
	while (loop < len)
	{
		int t = 0;
		
		if (text[loop] >= 65 && text[loop] <= 90)
		{
			int temp = text[loop];

			temp -= 65;
			temp *= 7;

			srcRect.left = 0 + temp;
			srcRect.top = 124;
			srcRect.right = 6 + temp;
			srcRect.bottom = 131;
			
		}
		if (text[loop] >= 97 && text[loop] <= 122)
		{
			int temp = text[loop];
			temp -= 97;
			temp *= 7;

			srcRect.left = 0 + temp;
			srcRect.top = 132;
			srcRect.right = 6 + temp;
			srcRect.bottom = 139;
		}
		if (text[loop] >= 48 && text[loop] <= 57)
		{
			int temp = text[loop];
			if (temp == '0') 
			{
				temp -= 39;
			} else 
			{
				temp -= 49;
			}
			temp *= 7;
			srcRect.left = 0 + temp + t;
			srcRect.top = 140;
			srcRect.right = 6 + temp + t;
			srcRect.bottom = 147;
		}
		if (text[loop] == 45)
		{
			srcRect.left = 70;
			srcRect.top = 140;
			srcRect.right = 76;
			srcRect.bottom = 147;
		}
		if (text[loop] == 61)
		{
			srcRect.left = 77;
			srcRect.top = 140;
			srcRect.right = 83;
			srcRect.bottom = 147;
		}
		if (text[loop] == 58)
		{
			srcRect.left = 84;
			srcRect.top = 140;
			srcRect.right = 90;
			srcRect.bottom = 147;
		}
		if (text[loop] == 95)
		{
			srcRect.left = 91;
			srcRect.top = 140;
			srcRect.right = 97;
			srcRect.bottom = 147;
		}
		if (text[loop] == ' ')
		{
			srcRect.left = 0;
			srcRect.top = 0;
			srcRect.right = 1;
			srcRect.bottom = 1;
		}
		destRect.left = x + (loop * 7);
		destRect.top = y;
		destRect.right = x + 6 + (loop * 7);
		destRect.bottom = y + 7;

		Blit(srcRect, destRect, SpaceShip);
		loop++;
	};
}
void DisplayScore()
{
	
	RECT srcRect, destRect;
	
	int loop = 0;
	
	char ch[5];
	
	wsprintf(ch,"%05d",Ship[playership - 1]->GetScore());

	while (loop < 5)
	{
		destRect.left = 555 + (loop * 15) + loop;
		destRect.top = 0;
		destRect.right = 570 + (loop * 15) + loop;
		destRect.bottom = 33;

		if (ch[loop] >= 48 && ch[loop] <= 57)
		{
			int temp = ch[loop];
			if (temp == '0') 
			{
				temp -= 39;
			} else 
			{
				temp -= 49;
			}
			
			
			temp *= 16;

			srcRect.left = 16 + temp;
			srcRect.top = 148;
			srcRect.right = 31 + temp;
			srcRect.bottom = 182;
		} else 
		{
			srcRect.left = 0;
			srcRect.top = 148;
			srcRect.right = 15;
			srcRect.bottom = 182;
		}

		Blit(srcRect, destRect, SpaceShip);
		loop++;
	};

}
void DisplayMissiles()
{
	RECT srcRect, destRect;
	
	int loop = 0;

	srcRect.left   = 0;
	srcRect.top    = 185;
	srcRect.right  = 12;
	srcRect.bottom = 197;

	while (loop < Ship[playership -1]->GetMissileNum())
	{
		destRect.left   = 628 - (loop * 12);
		destRect.top    = 35;
		destRect.right  = 640 - (loop * 12);
		destRect.bottom = 47;
		Blit(srcRect, destRect, SpaceShip);
		loop++;
	};
	
};

void InitGlobals()
{
	krot = 0;
	Fire = false;
	int loop = 0;
	WorldX = 0;
	WorldY = 0;
	
	if (Ship != NULL) delete[] Ship;
	
	Ship = new TSpaceShip*[TotalShips];

	while (loop < playernum)
	{
		if (Ship[loop] != NULL) delete Ship[loop];
		Ship[loop] = new TPlayer();
		Ship[loop]->InitSpaceShip(0,0,0,0,loop,PlayerName,100);
		Ship[loop]->Active(true);
		loop++;
	};
	loop = playernum;
	while (loop < (TotalShips))
	{
		if (Ship[loop] != NULL) delete Ship[loop];
		Ship[loop] = new TDrone();
		Ship[loop]->InitSpaceShip(((rand() % 32767) - 16384),((rand() % 32767) - 16384), 0, 1,loop);
		//Ship[loop]->InitSpaceShip(0,75, 0, 1);
		Ship[loop]->Active(true);
		loop ++;
    };
	loop = 0;
	
	if (Smoke != NULL) delete[] Smoke;
	Smoke = new TSmoke[TotalShips];

	while (loop < (TotalShips))
	{
		Smoke[loop].InitSmoke(Ship[loop]->GetX(), Ship[loop]->GetY(), Ship[loop]->GetDirection());
		Smoke[loop].Active(true);
		loop++;

	};
	loop = 0;
	while (loop < (20))
	{
		MissileSmoke[loop].InitSmoke(0,0,0,144,159);
		MissileSmoke[loop].Active(false);
		loop++;

	};
	loop = 0;
	int temp;
	
	if (tp != NULL) delete[] tp;

	tp = new TPowerUp*[PowerUpNum];

	while (loop < (PowerUpNum))
	{
		if (tp[loop] != NULL) delete tp[loop];

		temp = rand() % 5;
		
		if (temp == 0)
			tp[loop] = new TPUMissile();
		else if (temp == 1)
			tp[loop] = new TPUHealth10();
		else if (temp == 2)
			tp[loop] = new TPUHealth25();
		else if (temp == 3)
			tp[loop] = new TPUHealth50();
		else if (temp == 4)
			tp[loop] = new TPU2xFireDist();
		
		tp[loop]->InitPowerUp(temp);

		loop++;

	};

}
void CheckForPickUp()
{
	int loop = 0,loop2, xs, ys, xp, yp, temp;
	while (loop < TotalShips)
	{
		loop2 = 0;
		while (loop2 < OldPowerUpNum)
		{	
			xs = Ship[loop]->GetX();
			ys = Ship[loop]->GetY();
			
			xp = tp[loop2]->GetX();
			yp = tp[loop2]->GetY();
			
			if (((xp > xs - 15) && (xp < xs + 15)) &&
				((yp > ys - 15) && (yp < ys + 15)))
			{
				
				if (tp[loop2]->GetNum() == 0)
					Ship[loop]->AddMissiles(5);

				else if (tp[loop2]->GetNum() == 1)
					Ship[loop]->Damage(-10);

				else if (tp[loop2]->GetNum() == 2)
					Ship[loop]->Damage(-25);

				else if (tp[loop2]->GetNum() == 3)
					Ship[loop]->Damage(-50);
				
				else if (tp[loop2]->GetNum() == 4)
					Ship[loop]->Set2xDamageFactor();

				delete tp[loop2];

				tp[loop2] = NULL;
				
				temp = rand() % 5;
				
				if (temp == 0)
					tp[loop2] = new TPUMissile();
				else if (temp == 1)
					tp[loop2] = new TPUHealth10();
				else if (temp == 2)
					tp[loop2] = new TPUHealth25();
				else if (temp == 3)
					tp[loop2] = new TPUHealth50();
				else if (temp == 4)
					tp[loop2] = new TPU2xFireDist();
				
				tp[loop2]->InitPowerUp(temp);
	
			};

			loop2++;
		};

		loop++;
	};
}
void DrawMenu()
{
	RECT destRect,srcRect;

	if (!Ship[playership - 1]->Active())
	{
		int clickoffset = 0;
		ti->GetMouseState();
		
		MouseX += ti->GetMouseX();
		MouseY += ti->GetMouseY();
		
		if (MouseX < 0) MouseX = 0;
		else if (MouseX > 640) MouseX = 640;
		
		if (MouseY < 0) MouseY = 0;
		else if (MouseY > 480) MouseY = 480;
		
		if (ti->LeftButtonPressed()) clickoffset = 31;

		if (MainMenu)
		{
			destRect.left   = 280;
			destRect.top    = 208;
			destRect.right  = 360;
			destRect.bottom = 272;

			srcRect.left    = 0;
			srcRect.top		= 0;
			srcRect.right	= 79;
			srcRect.bottom	= 64;

			Blit(srcRect, destRect, GUISurface);

			if (ti->LeftButtonReleased())
			{
				if ((MouseX > 284) && (MouseX < 355) && (MouseY > 212) && (MouseY < 229))
				{
					TotalShips = Shipnum + playernum;
					OldPowerUpNum = PowerUpNum;
					PostMessage(hWnd, WM_KEYDOWN, VK_F1, 0);
				}
				if ((MouseX > 284) && (MouseX < 355) && (MouseY > 231) && (MouseY < 248))
				{
					MainMenu = false;
					OptionsMenu = true;
					QuitMessage = false;
					OldRJ = randomjitter;
					OldShipnum = Shipnum;
					OldParticles = ExplosionParticles;
					OldPowerUpNum = PowerUpNum;
				}
				if ((MouseX > 284) && (MouseX < 355) && (MouseY > 250) && (MouseY < 267))
				{
					MainMenu = false;
					OptionsMenu = false;
					QuitMessage = true;
				}
			}
			
		}
		if (OptionsMenu)
		{
			destRect.left   = 232;
			destRect.top    = 188;
			destRect.right  = 409;
			destRect.bottom = 292;

			srcRect.left    = 81;
			srcRect.top		= 0;
			srcRect.right	= 258;
			srcRect.bottom	= 104;

			Blit(srcRect, destRect, GUISurface);
			
			// Random Jitter
			
			destRect.left   = 380;
			destRect.top    = 192;
			destRect.right  = 397;
			destRect.bottom = 209;
			
			srcRect.top		= 0;
			srcRect.bottom	= 17;
			
			if (randomjitter)
			{
				srcRect.left    = 260;
				srcRect.right	= 277;
			} else
			{
				srcRect.left    = 279;
				srcRect.right	= 296;
			}

			Blit(srcRect, destRect, GUISurface);

			char ch[4];
			int len = wsprintf(ch,"%d",Shipnum);
			
			OzText(389,220,ch,len);
			
			len = wsprintf(ch,"%d",ExplosionParticles);
			
			OzText(389,239,ch,len);
			
			len = wsprintf(ch,"%d",PowerUpNum);
			
			OzText(389,258,ch,len);

			if (ti->LeftButtonReleased())
			{
				if ((MouseX > 380) && (MouseX < 397) && (MouseY > 192) && (MouseY < 209))
				{
					randomjitter = !randomjitter;
				}
				if ((MouseX > 236) && (MouseX < 307) && (MouseY > 271) && (MouseY < 288))
				{
					MainMenu = true;
					OptionsMenu = false;
					QuitMessage = false;
				}
				if ((MouseX > 334) && (MouseX < 405) && (MouseY > 271) && (MouseY < 288))
				{
					randomjitter = OldRJ;
					Shipnum = OldShipnum;
					ExplosionParticles = OldParticles;
					PowerUpNum = OldPowerUpNum;

					MainMenu = true;
					OptionsMenu = false;
					QuitMessage = false;
				}

			}
			
			if (ti->LeftButtonPressed() || ti->RightButtonPressed())
			{
				if ((MouseX > 372) && (MouseX < 405) && (MouseY > 211) && (MouseY < 228))
				{
					
					if (ti->LeftButtonPressed())
						Shipnum++;
					else if (ti->RightButtonPressed())
						Shipnum--;
					
					if (Shipnum > 125) Shipnum = 125;
					if (Shipnum < 1)   Shipnum = 1;

				}		
				if ((MouseX > 372) && (MouseX < 405) && (MouseY > 230) && (MouseY < 247))
				{
					if (ti->LeftButtonPressed())
						ExplosionParticles++;
					else if (ti->RightButtonPressed())
						ExplosionParticles--;
					if (ExplosionParticles > 5000) ExplosionParticles = 5000;
					if (ExplosionParticles < 10)   ExplosionParticles = 10;
				}		
				if ((MouseX > 372) && (MouseX < 405) && (MouseY > 249) && (MouseY < 266))
				{
					if (ti->LeftButtonPressed())
						PowerUpNum++;
					else if (ti->RightButtonPressed())
						PowerUpNum--;

					if (PowerUpNum > 1500) PowerUpNum = 1500;
					if (PowerUpNum < 100)  PowerUpNum = 100;
				}		
			}

		}
		if (QuitMessage)
		{
			destRect.left   = 196;
			destRect.top    = 218;
			destRect.right  = 444;
			destRect.bottom = 262;

			srcRect.left    = 0;
			srcRect.top		= 106;
			srcRect.right	= 248;
			srcRect.bottom	= 151;

			Blit(srcRect, destRect, GUISurface);
			
			if (ti->LeftButtonReleased())
			{
				if ((MouseX > 200) && (MouseX < 271) && (MouseY > 241) && (MouseY < 258))
				{
					PostMessage(hWnd, WM_CLOSE, 0, 0);
				}
				if ((MouseX > 368) && (MouseX < 439) && (MouseY > 241) && (MouseY < 258))
				{
					MainMenu = true;
					OptionsMenu = false;
					QuitMessage = false;
				}
			}
		}


		destRect.left   = MouseX;
		destRect.top    = MouseY;
		destRect.right  = MouseX + 30;
		destRect.bottom = MouseY + 30;

		srcRect.left    = 434;
		srcRect.top		= 0 + clickoffset;
		srcRect.right	= 464;
		srcRect.bottom	= 30 + clickoffset;
		
		Blit(srcRect, destRect, SpaceShip);

		
	}
}
void UpdateFrame()
{
    RECT                        srcRect;
	RECT                        destRect;
    HRESULT                     hRet;
	DDSURFACEDESC2				ddsd;


	ClearBackBuffer();

	
       	
	srcRect.left = 0;
    srcRect.top = 0;
    srcRect.right = 640;
    srcRect.bottom = 480;

	destRect.left = 0;
	destRect.top = 0;
	destRect.right = 640;
	destRect.bottom = 480;
    
	Blit(srcRect, destRect, Starfield, DDBLT_WAIT);
	
	ClearBackgr();
	
	ddsd.dwSize = sizeof(ddsd);

	if (ti->KeyReleased(DIK_P)) Pause = !Pause;

	if (Ship[playership -1] != NULL)
	{
		readkey = !readkey;
	
		if (readkey && ti->KeyPressed(DIK_LEFT)) krot -= 1;
		if (readkey && ti->KeyPressed(DIK_RIGHT)) krot += 1;
		
		if (ti->KeyReleased(DIK_UP)) thrust ++;
		if (ti->KeyReleased(DIK_DOWN)) thrust --;
		
		if (thrust < 0) thrust = 0;
		if (thrust > 3) thrust = 3;
		
		if (ti->KeyPressed(DIK_SPACE)) 
		{
			Fire = !Fire;
		}
		if (ti->KeyReleased(DIK_SPACE)) Fire = false;
		
		if (!ti->KeyReleased(DIK_LMENU)) 
		{
			Ship[playership - 1]->SetLaunch(false);
			
		};
		if (ti->KeyReleased(DIK_LMENU)) 
		{
			Ship[playership - 1]->SetLaunch(true);
			
		};
	} else if (ti->KeyReleased(DIK_LMENU)) InitGlobals(), krot = 0;
	Ship[playership - 1]->SetFire(Fire);

	if (krot < 0.0) krot = 15.0f;
	if (krot > 15.0) krot = 0.0f;
    

	rot = krot;
	
	if (rot < 0) rot += 15;
	if (rot > 15) rot -= 15;
    if (!Pause)
	{
		Ship[playership - 1]->SetDirection(krot);
		Ship[playership - 1]->SetThrust(thrust);
	
		SetDir(krot);
		SetThrust(thrust);
	
		if (thrust > 0) SetDir(krot);
		if (thrust == 0) SetDir(-1);

		NextFrame(WorldX, WorldY);
		Ship[playership - 1]->SetX(WorldX); 
		Ship[playership - 1]->SetY(WorldY); 
	};
	
	{
		int loop = 0;
		while (loop < TotalShips)
		{
			if (Ship[loop]->Active() && Ship[loop] != NULL )
			{
				{
					int x = Ship[loop]->GetX();
					int y = Ship[loop]->GetY();
					x -= WorldX;
					y -= WorldY;
					x += 320;
					y += 220;
					char ch[65] ;
					int len = wsprintf(ch,"%d:%s:%d",Ship[loop]->GetScore(),Ship[loop]->GetName(),Ship[loop]->GetHealth());
				
					int temp;
					temp = len;
					temp *= 7;
					temp /= 2;
					if (x < temp) x = temp;
					if (x > 640 - temp) x = 640 - temp;
					if (y < 4) y = 4;
					if (y > 476) y = 476;
					
					OzText(x,y,ch,len);
											
				}
	
				if (Ship[loop]->IsFiring()) 
				{
	

					shot[shotcount].InitFire(Ship[loop]->GetX(), Ship[loop]->GetY(), Ship[loop]->GetDirection(), Ship[loop]->GetThrust(), loop);
					shot[shotcount].Active(true);
				
					shotcounter[shotcount] = 0;
				
					shotcount++;

					if (shotcount == 100) shotcount = 0;
				};
				if (Ship[loop]->IsLaunching()) 
				{
	
					Missile[missilecount].InitMissile(Ship[loop]->GetX(), Ship[loop]->GetY(), Ship[loop]->GetDirection(), 3, Ship[loop], loop);
					Missile[missilecount].Active(true);
		
					missilecounter[missilecount] = 0;
					MissileSmoke[missilecount].Active(true);
					missilecount ++;
					
					if (missilecount == 20) missilecount = 0;
				};

				srcRect = Ship[loop]->GetFrameData();
				
				destRect.left = -15 + ((Ship[loop]->GetX() - WorldX) + 320);
				destRect.top = -15 + ((Ship[loop]->GetY() - WorldY) + 240);
				destRect.right = 15 + ((Ship[loop]->GetX() - WorldX) + 320); 
				destRect.bottom = 15 + ((Ship[loop]->GetY() - WorldY) + 240);
			
				if (!Pause) Ship[loop]->NextFrame();
				
				Smoke[loop].SetDirection(Ship[loop]->GetDirection());
				
				Blit(srcRect, destRect, SpaceShip/*, DDBLT_KEYSRC | DDBLT_KEYDEST | DDBLT_WAIT*/);
			};
			loop++;
		};
		loop = 0;
		while (loop < 20)
		{
			if (Missile[loop].Active())
			{
				if (!Pause) Missile[loop].NextFrame();
				srcRect = Missile[loop].GetFrameData();
			
				destRect.left = -6 + ((Missile[loop].GetX() - WorldX) + 320);
				destRect.top = -6 + ((Missile[loop].GetY() - WorldY) + 240);
				destRect.right = 6 + ((Missile[loop].GetX() - WorldX) + 320); 
				destRect.bottom = 6 + ((Missile[loop].GetY() - WorldY) + 240);
				
				MissileSmoke[loop].SetDirection(Missile[loop].GetDirection()); 				
				
				Blit(srcRect, destRect, SpaceShip);
			
				if (!Pause) missilecounter[loop] ++;
				if (missilecounter[loop] > 75)
				{
					Missile[loop].Active(false);
					//if (Particle[particlecount] != NULL) delete Particle[particlecount];
					Particle[particlecount] = new TParticles();

					Particle[particlecount]->InitParticles(Missile[loop].GetX(), Missile[loop].GetY());
					Particle[particlecount]->Active(true);

					particlecounter[particlecount] = 0;
					particlecount ++;

					if (particlecount == 10) particlecount = 0;
	
				}

			}
			loop++;
		};
		loop = 0;
		while (loop < OldPowerUpNum)
		{
			{
				srcRect = tp[loop]->GetFrameData();
			
				destRect.left = -8 + ((tp[loop]->GetX() - WorldX) + 320);
				destRect.top = -9 + ((tp[loop]->GetY() - WorldY) + 240);
				destRect.right = 8 + ((tp[loop]->GetX() - WorldX) + 320); 
				destRect.bottom = 9 + ((tp[loop]->GetY() - WorldY) + 240);
				
							
				Blit(srcRect, destRect, SpaceShip);
							
			}
			loop++;
		};

	};
	if (Starfield->Lock(NULL, &ddsd, DDLOCK_WAIT, NULL) == DD_OK)
	{
		int loop = 0;
		while (loop < 100)
		{
			if (!Pause) ts[loop].NextFrame();
			
			if (thrust > 1) Line(ddsd.lpSurface, ddsd.lPitch, tsold[loop].GetX(), tsold[loop].GetY(), ts[loop].GetX(), ts[loop].GetY(), ts[loop].GetCol());
			else SetPixel(ddsd.lpSurface, ddsd.lPitch, ts[loop].GetX() , ts[loop].GetY(), ts[loop].GetCol());
			if (!Pause) tsold[loop].NextFrame();

			if ((ts[loop].GetY() > 481 || ts[loop].GetY() < -1) ||
				(ts[loop].GetX() > 641 || ts[loop].GetX() < -1))
			{
				ts[loop].InitStar2();
				tsold[loop].SetX(ts[loop].GetX());
				tsold[loop].SetY(ts[loop].GetY());
				tsold[loop].SetCol(ts[loop].GetCol());
				tsold[loop].SetSpeed(ts[loop].GetSpeed());
			};		
			
			loop++;
		};
		
		loop = 0;
		int x, y;

		while (loop < 100)
		{
			
			if (shot[loop].Active() && shotcounter[loop] < 15) 
			{	
				if (!Pause) shotcounter[loop]++;
	
				x = (shot[loop].GetX() - WorldX) + 320;
				y = (shot[loop].GetY() - WorldY) + 240;
				
				SetPixel(ddsd.lpSurface, ddsd.lPitch, x, y, 15);
				
				

				if (shot[loop].GetOwner() >= playernum)
				{
					SetPixel(ddsd.lpSurface, ddsd.lPitch, x, y - 1, 12);
					SetPixel(ddsd.lpSurface, ddsd.lPitch, x, y + 1, 12);
					SetPixel(ddsd.lpSurface, ddsd.lPitch, x - 1, y, 12);
					SetPixel(ddsd.lpSurface, ddsd.lPitch, x + 1, y, 12);
				} else
				{
					SetPixel(ddsd.lpSurface, ddsd.lPitch, x, y - 1, 9);
					SetPixel(ddsd.lpSurface, ddsd.lPitch, x, y + 1, 9);
					SetPixel(ddsd.lpSurface, ddsd.lPitch, x - 1, y, 9);
					SetPixel(ddsd.lpSurface, ddsd.lPitch, x + 1, y, 9);
				}
				/*if (Ship[shot[loop].GetOwner()]->GetName() == "Drone")
				{
					SetPixel(ddsd.lpSurface, ddsd.lPitch, x, y - 1, 12);
					SetPixel(ddsd.lpSurface, ddsd.lPitch, x, y + 1, 12);
					SetPixel(ddsd.lpSurface, ddsd.lPitch, x - 1, y, 12);
					SetPixel(ddsd.lpSurface, ddsd.lPitch, x + 1, y, 12);
				} else
				{
					SetPixel(ddsd.lpSurface, ddsd.lPitch, x, y - 1, 9);
					SetPixel(ddsd.lpSurface, ddsd.lPitch, x, y + 1, 9);
					SetPixel(ddsd.lpSurface, ddsd.lPitch, x - 1, y, 9);
					SetPixel(ddsd.lpSurface, ddsd.lPitch, x + 1, y, 9);
				}*/
				if (!Pause) shot[loop].NextFrame();
			}
			else if (shotcounter[loop] >= 15)
			{
				shot[loop].Active(false);
				shotcounter[loop] = 0;
			}
			
			loop++;
		};
		{
			loop = 0;
			int loop2 = 0, x , y;
			while (loop < 10)
			{
				if (Particle[loop] != NULL)
				{
					Particle[loop]->NextFrame();
					loop2 = 0;
					while (loop2 < Particle[loop]->GetNumParticles())
					{
						x = (Particle[loop]->GetX(loop2) - WorldX) + 320;
						y = (Particle[loop]->GetY(loop2) - WorldY) + 240;
						SetPixel(ddsd.lpSurface, ddsd.lPitch, x, y, Particle[loop]->GetColour(loop2));
						loop2++;

					};
					particlecounter[loop]++;
					if (particlecounter[loop] > 50) delete Particle[loop], Particle[loop] = NULL, particlecount = 0;
						
				}
				loop++;
			};
		
		}
		{
			loop = 0;
			int loop2 = 0, x , y;
			while (loop < TotalShips)
			{
				if (Ship[loop]->Active()/* != NULL*/)
				{
					Smoke[loop].NextFrame(Ship[loop]->GetX(), Ship[loop]->GetY());
					loop2 = 0;
					while (loop2 < Smoke[loop].GetNumParticles())
					{
						x = (Smoke[loop].GetX(loop2) - WorldX) + 320;
						y = (Smoke[loop].GetY(loop2) - WorldY) + 240;
						SetPixel(ddsd.lpSurface, ddsd.lPitch, x, y, Smoke[loop].GetColour(loop2));
						
						loop2++;

					};
					
				}
				loop++;
			};
		
		}
		{
			loop = 0;
			int loop2 = 0, x , y;
			while (loop < 20)
			{
				if (Missile[loop].Active())
				{
					MissileSmoke[loop].NextFrame(Missile[loop].GetX(), Missile[loop].GetY());
					loop2 = 0;
					while (loop2 < MissileSmoke[loop].GetNumParticles())
					{
						x = (MissileSmoke[loop].GetX(loop2) - WorldX) + 320;
						y = (MissileSmoke[loop].GetY(loop2) - WorldY) + 240;
						SetPixel(ddsd.lpSurface, ddsd.lPitch, x, y, MissileSmoke[loop].GetColour(loop2));
						
						loop2++;

					};
					
				}
				loop++;
			};
		
		}

		{
			x = 0;
			int Health = Ship[playership - 1]->GetHealth();
			float colour = 224.0f;
			float dcolour = 31.0f / 200.0f;
		
		
			while (x < (Health * 2))
			{
				Line(ddsd.lpSurface, ddsd.lPitch, x, 0, x, 25,colour);
				colour += dcolour;
				x++;
			};		
		}
		Starfield->Unlock(NULL);
	};
	
	DisplayScore();
	DisplayMissiles();
	
	if (!Pause) CheckForCollision();
	
	CheckForPickUp();
	
	DrawMenu();

	/*if (hRet != DD_OK)
        return;*/
	
	
	
	
   
    // Flip the surfaces
    while (TRUE)
    {
        hRet = FrontBuffer->Flip(NULL, 0);
        if (hRet == DD_OK)
            break;
        if (hRet == DDERR_SURFACELOST)
        {
            hRet = RestoreAll();
            if (hRet != DD_OK)
                break;
        }
        if (hRet != DDERR_WASSTILLDRAWING)
            break;
    }
}




//-----------------------------------------------------------------------------
// Name: WindowProc()
// Desc: The Main Window Procedure
//-----------------------------------------------------------------------------
long FAR PASCAL 
WindowProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	HRESULT hRet;
    switch (message)
    {
        case WM_ACTIVATEAPP:
            // Pause if minimized or not the top window
            g_bActive = (wParam == WA_ACTIVE) || (wParam == WA_CLICKACTIVE);
            return 0L;
		
		case WM_KILLFOCUS:
			//delete ti;
			KeyboardLost = true;
			return 0L;
		
		case WM_SETFOCUS:
			if (KeyboardLost)
			{
				//delete ti;
				//ti = new TDInput();
				/*if ((hRet = ti->TDInputInit(hInstance, hWnd, true, false)) != DI_OK) 
					InitFail(hWnd, hRet, "Direct Input Initialisation FAILED");*/
			}
			KeyboardLost = false;
			return 0L;

		/*case WM_COMMAND:
			return 0L;
		case WM_SYSCOMMAND:
			return 0L;*/

        case WM_DESTROY:
            // Clean up and close the app
            ReleaseAllObjects();
            PostQuitMessage(0);
            return 0L;

        case WM_KEYDOWN:
            // Handle any non-accelerated key commands
            switch (wParam)
            {
                case VK_ESCAPE:
                case VK_F12:
                    PostMessage(hWnd, WM_CLOSE, 0, 0);
                    return 0L;
				case VK_F1:
					InitGlobals();
					return 0L;
            }
            break;

        case WM_SETCURSOR:
            // Turn off the cursor since this is a full-screen app
            SetCursor(NULL);
            return TRUE;

    }
    return DefWindowProc(hWnd, message, wParam, lParam);
}




//-----------------------------------------------------------------------------
// Name: InitApp()
// Desc: Do work required for every instance of the application:
//          Create the window, initialize data
//-----------------------------------------------------------------------------
static HRESULT
InitApp(HINSTANCE hInstance, int nCmdShow)
{
    
    WNDCLASS                    wc;
    DDSURFACEDESC2              ddsd;
    DDSCAPS2                    ddscaps;
    HRESULT                     hRet;
    LPDIRECTDRAW                pDD;

    // Set up and register window class
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = WindowProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_MAIN_ICON));
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH )GetStockObject(BLACK_BRUSH);
    wc.lpszMenuName = NAME;
    wc.lpszClassName = NAME;
    RegisterClass(&wc);

    // Create a window
    hWnd = CreateWindowEx(WS_EX_TOPMOST,
                          NAME,
                          TITLE,
                          WS_POPUP,
                          0,
                          0,
                          GetSystemMetrics(SM_CXSCREEN),
                          GetSystemMetrics(SM_CYSCREEN),
                          NULL,
                          NULL,
                          hInstance,
                          NULL);

    if (!hWnd)
        return FALSE;
    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);
    SetFocus(hWnd);

    ///////////////////////////////////////////////////////////////////////////
    // Create the main DirectDraw object
    ///////////////////////////////////////////////////////////////////////////
    hRet = DirectDrawCreate(NULL, &pDD, NULL);
    if (hRet != DD_OK)
        return InitFail(hWnd, hRet, "DirectDrawCreate FAILED");

    // Fetch DirectDraw4 interface
    hRet = pDD->QueryInterface(IID_IDirectDraw4, (LPVOID *) & DirectDraw);
    if (hRet != DD_OK)
        return InitFail(hWnd, hRet, "QueryInterface FAILED");

    // Get exclusive mode
    hRet = DirectDraw->SetCooperativeLevel(hWnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN);
    if (hRet != DD_OK)
        return InitFail(hWnd, hRet, "SetCooperativeLevel FAILED");

    // Set the video mode to 640x480x8
    hRet = DirectDraw->SetDisplayMode(640, 480, 8, 0, 0);
    if (hRet != DD_OK)
        return InitFail(hWnd, hRet, "SetDisplayMode FAILED");

    // Create the primary surface with 1 back buffer
    ZeroMemory(&ddsd, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
                          DDSCAPS_FLIP |
                          DDSCAPS_COMPLEX;
    ddsd.dwBackBufferCount = 1;
    hRet = DirectDraw->CreateSurface(&ddsd, &FrontBuffer, NULL);
    if (hRet != DD_OK)
        return InitFail(hWnd, hRet, "CreateSurface FAILED");

    // Get a pointer to the back buffer
    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
    hRet = FrontBuffer->GetAttachedSurface(&ddscaps, &BackBuffer);
    if (hRet != DD_OK)
        return InitFail(hWnd, hRet, "GetAttachedSurface FAILED");

    // Create and set the palette
    Palette256 = DDLoadPalette(DirectDraw, szBitmap);
    if (Palette256)
        FrontBuffer->SetPalette(Palette256);

    // Create the offscreen surface, by loading our bitmap.
    SpaceShip = DDLoadBitmap(DirectDraw, szBitmap, 0, 0);
    if (SpaceShip == NULL)
        return InitFail(hWnd, hRet, "DDLoadBitmap FAILED");

	ZeroMemory(&ddsd, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
    ddsd.dwWidth = 640;
    ddsd.dwHeight = 480;

    if (DirectDraw->CreateSurface(&ddsd, &Starfield, NULL) != DD_OK)
        return NULL;
	
	GUISurface = DDLoadBitmap(DirectDraw, szGui, 0, 0);
    if (GUISurface == NULL)
        return InitFail(hWnd, hRet, "DDLoadBitmap FAILED");

    // Set the color key for this bitmap (black)
    
	//DDSetColorKey(SpaceShip, RGB(0, 0, 0));
	
	DDSetColorKey(SpaceShip, 0);
	DDSetDestColorKey(SpaceShip, 0);

	DDSetColorKey(GUISurface, 0);

	DDSetColorKey(Starfield, 0);
	//DDSetDestColorKey(Starfield, 15);

	DDSetColorKey(BackBuffer, 0);
	DDSetDestColorKey(BackBuffer, 255);

	if ((hRet = ti->TDInputInit(hInstance, hWnd, true, true)) != DI_OK) 
		InitFail(hWnd, hRet, "Direct Input Initialisation FAILED");
    
	

	DirectDraw->CreateClipper(0, &Clipper, NULL);
	
	Clipper->SetHWnd(0, hWnd);
	
	BackBuffer->SetClipper(Clipper);

	::hInstance = hInstance;

	return DD_OK;
}




//-----------------------------------------------------------------------------
// Name: WinMain()
// Desc: Initialization, message loop
//-----------------------------------------------------------------------------
int PASCAL
WinMain(HINSTANCE hInstance,
        HINSTANCE hPrevInstance,
        LPSTR lpCmdLine,
        int nCmdShow)
{
	MSG                         msg;
	
	ti = new TDInput();
    if (InitApp(hInstance, nCmdShow) != DD_OK)
        return FALSE;
	
	srand( (unsigned)time( NULL ) );

	InitStarfield();
	InitGlobals();	

	Ship[playership - 1]->Active(false);	

	while (TRUE)
    {
        if (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
        {
            if (!GetMessage(&msg, NULL, 0, 0))
                return msg.wParam;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
        else if (g_bActive)
        {
			ti->GetKeyboardState();
            UpdateFrame();
        }
        else
        {
            // Make sure we go to sleep if we have nothing else to do
            WaitMessage();
        }
    }
}


