class TDInput 
{
	private:
		
		HWND				hWnd;
		LPDIRECTINPUT		DInput; 
		LPDIRECTINPUTDEVICE KeyBoard;
		LPDIRECTINPUTDEVICE Mouse;
		HRESULT				hRet;
		char				buffer[256]; 
		bool				bufferr[256];
		bool				bufferp[256];
		DIMOUSESTATE		MouseState;
		
		bool LeftPressed;
		bool RightPressed;
		bool MiddlePressed;

		bool LeftReleased;
		bool RightReleased;
		bool MiddleReleased;
		
		HRESULT	InitFail(HWND hWnd, HRESULT hRet, LPCTSTR szError,...)
		{
			char                        szBuff[128];
			va_list                     vl;

			va_start(vl, szError);
			vsprintf(szBuff, szError, vl);
			//ReleaseAllObjects();
			MessageBox(hWnd, szBuff, "An Error has Occurred", MB_OK);
			DestroyWindow(hWnd);
			va_end(vl);
			return hRet;
		}
		HRESULT CreateMouseDevice()
		{
			if ((hRet = DInput->CreateDevice(GUID_SysMouse, &Mouse, NULL)) != DI_OK) 
				return InitFail(hWnd,hRet,"Create Mouse Device Failed"); 
		
			if ((hRet = Mouse->SetDataFormat(&c_dfDIMouse)) != DI_OK) 
				return InitFail(hWnd,hRet,"Set Mouse Data Format Failed"); 

			if ((hRet = Mouse->SetCooperativeLevel(hWnd,DISCL_FOREGROUND | DISCL_NONEXCLUSIVE)) != DD_OK) 
				return InitFail(hWnd,hRet,"Set Mouse Cooperative Level Failed"); 

			if ((hRet = Mouse->Acquire()) != DI_OK)
				return InitFail(hWnd,hRet,"Mouse acquisition Failed"); 
			
			return DI_OK;
		}
		
		HRESULT CreateKeyboardDevice()
		{
			if ((hRet = DInput->CreateDevice(GUID_SysKeyboard, &KeyBoard, NULL)) != DI_OK) 
				return InitFail(hWnd,hRet,"Create Keyboard Device Failed"); 
		 
			if ((hRet = KeyBoard->SetDataFormat(&c_dfDIKeyboard)) != DI_OK) 
				return InitFail(hWnd,hRet,"Set Keyboard Data Format Failed"); 

			if ((hRet = KeyBoard->SetCooperativeLevel(hWnd,DISCL_FOREGROUND | DISCL_NONEXCLUSIVE)) != DI_OK) 
				return InitFail(hWnd,hRet,"Set Keyboard Cooperative Level Failed"); 
	
			if ((hRet = KeyBoard->Acquire()) != DI_OK)
				return InitFail(hWnd,hRet,"Keyboard acquisition Failed");

			return DI_OK;
		}


	public:
		
		TDInput() {};
		~TDInput()
		{
			if (DInput != NULL)
			{
				if (KeyBoard != NULL)
				{
					KeyBoard->Release();
					KeyBoard = NULL;
				}
				if (Mouse != NULL)
				{
					Mouse->Release();
					Mouse = NULL;
				}
				DInput->Release();
				DInput = NULL;
			};	
		};


		HRESULT TDInputInit(HINSTANCE hInstance, HWND hWnd, bool Keyboardb = false, bool Mouseb = false)
		{
			this->hWnd = hWnd;

			if ((hRet = DirectInputCreate(hInstance, DIRECTINPUT_VERSION, &DInput, NULL)) != DI_OK) 
				InitFail(hWnd,hRet,"Direct Input Create Failed"); 
			
			if (Keyboardb)
			{
				if ((hRet = CreateKeyboardDevice()) != DI_OK) return hRet;
			}
			if (Mouseb)
			{
				if ((hRet = CreateMouseDevice()) != DI_OK) return hRet;	
			}
			return DI_OK;
		}

		HRESULT GetKeyboardState()
		{
			
			if (KeyBoard->GetDeviceState(sizeof(buffer),(LPVOID)&buffer) != DI_OK)
				InitFail(hWnd,hRet,"Get KeyBoard State Failed"); 
			int loop = 0;
			while (loop < 256)
			{
				if (KeyPressed(loop)) bufferp[loop] = true;
				else if (bufferr[loop]) bufferr[loop] = false;
				else
				{
					if (bufferp[loop]) bufferr[loop] = true;
					bufferp[loop] = false;
				}
				loop++;
			};
			return DI_OK;

		}

		HRESULT GetMouseState()
		{
			if (Mouse->GetDeviceState(sizeof(MouseState),(LPVOID)&MouseState) != DI_OK)
				InitFail(hWnd,hRet,"Get Mouse State Failed"); 
			
			if (LeftButtonPressed()) LeftPressed = true;
			else if (LeftReleased) LeftReleased = false;
			else
			{
				if (LeftPressed) LeftReleased = true;
				LeftPressed = false;
			}
			if (RightButtonPressed()) RightPressed = true;
			else if (RightReleased) RightReleased = false; 
			else
			{
				if (RightPressed) RightReleased = true;
				RightPressed = false;
			}
			if (MiddleButtonPressed()) MiddlePressed = true;
			else if (MiddleReleased) MiddleReleased = false; 
			else 
			{
				if (MiddlePressed) MiddleReleased = true;
				MiddlePressed = false;
			}
			return DI_OK;
		}

		int GetMouseX()
		{
			return MouseState.lX;
		}

		int GetMouseY()
		{
			return MouseState.lY;
		}
		
		bool LeftButtonPressed()
		{
			if (MouseState.rgbButtons[0] != 0) return true;
			else return false;
		}
		bool RightButtonPressed()
		{
			if (MouseState.rgbButtons[1] != 0) return true;
			else return false;
		}
		bool MiddleButtonPressed()
		{
			if (MouseState.rgbButtons[2] != 0) return true;
			else return false;
		}

		bool LeftButtonReleased()
		{
			return LeftReleased;
		}
		bool RightButtonReleased()
		{
			return RightReleased;
		}
		bool MiddleButtonReleased()
		{
			return MiddleReleased;
		}
		bool KeyPressed(int a)
		{
			if (buffer[a] & 0x80) return true;
			else return false;
		}
		bool KeyReleased(int a)
		{
			return bufferr[a];
		}
};