
#define M_PI 3.1415

class TMaths {
	public:
		float Sine(unsigned char s)
		{
			if ((s >= 0 ) && (s <= 255)) return sin(s*(M_PI/128));
			return 0;
		}

		float CoSine(unsigned char c)
		{
			if ((c >= 0 ) && (c <= 255)) return cos(c*(M_PI/128));;
			return 0;
		}

};

class TVertex {
	private:
   		int x,y;
	public:
		virtual int GetX() = 0;
		virtual int GetY() = 0;

		virtual void SetX(int)  = 0;
		virtual void SetY(int) = 0;
};
class T2dVertex : TVertex {
	private:
   		int x,y;
	public:
		T2dVertex() {}
		T2dVertex(int xx, int yy)
		{
      		x = xx;
			y = yy;
		}

		int GetX() { return x;}
		int GetY() { return y;}

		void SetX(int xx) { x = xx; }
		void SetY(int yy) { y = yy; }
};

class T3dVertex : TVertex {
	private:
   		int x,y,z,s,t;
   		T2dVertex *ViewVertex;
		T3dVertex *WorldVertex;
		static int dist;
		static int prp;
		static int exaggerate;
		int Colour;
	public:
   		T3dVertex(int xx, int yy, int zz, int colour, int ss=0, int tt=0)
		{
			x = xx;
			y = yy;
			z = zz;
			Colour = colour;
			s = ss;
			t = tt;
			
		}

		int GetX() { return x;}
		int GetY() { return y;}
		int GetZ() { return z;}
		int GetS() { return s;}
		int GetT() { return t;}
		int GetColour() { return Colour; }

		void SetX(int xx) { x = xx; }
		void SetY(int yy) { y = yy; }
		void SetZ(int zz) { z = zz; }
		void SetS(int ss) { s = ss; }
		void SetT(int tt) { t = tt; }
		void SetColour(int colour) { Colour = colour; }

		T2dVertex *GetVertex() { return ViewVertex; }
		T3dVertex *GetWorldVertex() { return WorldVertex; }

		void Convertto2d(float xang, float yang, float zang,int dist=100,int prp=500, int exaggerate=1)
		{
			TMaths *tm;
			tm = new TMaths;

		    float sxa = tm->Sine(xang);
			float sya = tm->Sine(yang);
			float sza = tm->Sine(zang);

			float cxa = tm->CoSine(xang);
			float cya = tm->CoSine(yang);
			float cza = tm->CoSine(zang);

			float x1 = (x * cza) - (y * sza);
			float y1 = (x * sza) + (y * cza);
			float z1 = z;

			float x2 = x1;
			float y2 = (y1 * cxa) - (z1 * sxa);
			float z2 = (y1 * sxa) + (z1 * cxa);

			x1 = (z2 * sya) + (x2 * cya);
			y1 = y2;
			z1 = (z2 * cya) - (x2 * sya);

			z1 = z1 * exaggerate;
			
			
			z1 = z1 - dist;
			if (z1 == 0) z1 = -1;
			
			WorldVertex = new T3dVertex((int)x1,(int)y1,(int)z1,this->Colour,this->s, this->t);
			ViewVertex = new T2dVertex((prp * (x1 / z1)), (prp * (y1 / z1)));

			delete tm;

		};
};
class TEdge {
	private:
   		T3dVertex *From;
		T3dVertex *To;

	public:
   		TEdge(T3dVertex *from, T3dVertex *to)
		{
  			From = from;
        	To = to;

		}

		T3dVertex *GetFromVertex() { return From; }
		T3dVertex *GetToVertex() { return To; }

		T2dVertex *GetFrom2dVertex() { return From->GetVertex(); }
		T2dVertex *GetTo2dVertex() { return To->GetVertex(); }

		T3dVertex *GetFrom3dVertex() { return From->GetWorldVertex(); }
		T3dVertex *GetTo3dVertex() { return To->GetWorldVertex(); }


//      int GetGradient() { return Gradient; }
		void SetFromVertex(T3dVertex *from) { From = from; }
		void SetToVertex(T3dVertex *to) { To = to; }
};
class TFace {
	private:
   		TEdge *One, *Two, *Three;
		int TexX, TexY;
		DWORD *Texture;
   		DWORD Colour;
	public:
   		TFace(TEdge *one, TEdge *two, TEdge *three, DWORD colour, DWORD *texture = NULL, int texX = 0, int texY = 0)
		{
      		One = one;
			Two = two;
			Three = three;
			Colour = colour;
			Texture = texture;
			TexX = texX;
			TexY = texY;
		}

   		TEdge *GetEdge1() { return One; }
		TEdge *GetEdge2() { return Two; }
		TEdge *GetEdge3() { return Three; }

		DWORD *GetTexture() { return Texture; }
		int GetTexX() { return TexX; }
		int GetTexY() { return TexY; }

		TEdge *GetEdge(int index)
		{
			
			if (index == 0) return One;
			if (index == 1) return Two;
			if (index == 2) return Three;
			return NULL;
		}

		DWORD GetColour() { return Colour;}

		void SetEdge1(TEdge *one) { One = one; }
		void SetEdge2(TEdge *two) { Two = two; }
		void SetEdge3(TEdge *three) { Three = Three; }
		
		
		bool Visible()
		{
			
			int ax = One->GetFrom2dVertex()->GetX() - Two->GetFrom2dVertex()->GetX();
			int ay = One->GetFrom2dVertex()->GetY() - Two->GetFrom2dVertex()->GetY();
			int bx = Three->GetFrom2dVertex()->GetX() - Two->GetFrom2dVertex()->GetX();
			int by = Three->GetFrom2dVertex()->GetY() - Two->GetFrom2dVertex()->GetY();

			int resvec = ax * by - ay * bx;
			if (resvec <= 0) return true;
			else return false;
		};
};
